#ifndef CE2_TCT_OTF_h
#define CE2_TCT_OTF_h

/*
* All the includes that are needed for code using this module to
* compile correctly should be #included here.
*/

#include "CE2_TST_Config.h"

#ifdef __cplusplus
extern "C"
{
#endif

/*
*  Object %name    : %
*  State           :  %state%
*  Creation date   :  Mar 29 2007
*  Last modified   :  %modify_time%
*/
/** @file
*  \brief A brief description of this module
*
*  \version CE2_TST_OTF.h#1:incl:1
*  \author Yermalayeu Ihar
*  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
*           All Rights reserved
*/

/************************ Defines *******************************/
/************************ Enums *********************************/
/************************ Typedefs  *****************************/
/************************ Structs  ******************************/
/************************ Public Variables **********************/
/************************ Public Functions **********************/

/*****************************************************************************
* Function Name:                                                           
* 	CE2_TST_OTF_AES2AES2HASH 		
* 
* Inputs:
*  @param[in/out] out - output stream for logs;
*
* Outputs:
*  @return - On success returns CE2_TST_VALID; else returns CE2_TST_FAILED.
*
* Description:																	
* 	Verify functionality of DX_AES2AES2HASH_OTF() function;
*
* Algorithm:		
*  -#  											
******************************************************************************/	
DxStatus CE2_TST_OTF_AES2AES2HASH(FILE *out);

/*****************************************************************************
* Function Name:                                                           
* 	CE2_TST_OTF_AES2DES2HASH 		
* 
* Inputs:
*  @param[in/out] out - output stream for logs;
*
* Outputs:
*  @return - On success returns CE2_TST_VALID; else returns CE2_TST_FAILED.
*
* Description:																	
* 	Verify functionality of DX_AES2DES2HASH_OTF() function;
*
* Algorithm:		
*  -#  											
******************************************************************************/	
DxStatus CE2_TST_OTF_AES2DES2HASH(FILE *out);

/*****************************************************************************
* Function Name:                                                           
* 	CE2_TST_OTF_DES2AES2HASH 		
* 
* Inputs:
*  @param[in/out] out - output stream for logs;
*
* Outputs:
*  @return - On success returns CE2_TST_VALID; else returns CE2_TST_FAILED.
*
* Description:																	
* 	Verify functionality of DX_DES2AES2HASH_OTF() function;
*
* Algorithm:		
*  -#  											
******************************************************************************/	
DxStatus CE2_TST_OTF_DES2AES2HASH(FILE *out);


#ifdef __cplusplus
}
#endif

#endif /*CE2_TCT_OTF_h*/
